<?PHP
/*****************************************************************************

  Abstract DB , MySQL module, version  2.1P

  Copyright (C) 1998  Muze 
  
  Modified for Phorum Version 3 - http://www.phorum.org

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*****************************************************************************

  for information,comments or bugreports, mail abstractdbmuze.nl

  Changelog:

  v2.1P 1 jan. 1999
    - modified for use with Phorum 3 - http://www.phorum.org
  
  v2.0b2 1 dec. 1998
    - fixed 2 small bugs in db->nextid() when db_sequence doesn't exist yet.

  v2.0b1 first version with the new interface.  
  
*****************************************************************************/

if ( !defined( "_DB_LAYER" ) ){
  define("_DB_LAYER", 1 );

class db {

  var $connect_id;
  var $type;

  function db($database_type="mysql") { 
    $this->type=$database_type;
  }

  function open($database, $host, $user, $password) {
    $this->connect_id=@mysql_pconnect($host, $user, $password); 
    if ($this->connect_id) {
      $result=@mysql_select_db($database);
      if (!$result) {
        @mysql_close($this->connect_id);
        $this->connect_id=$result;
      }
      return $this->connect_id;
    }
    else{
      mysql_pconnect($host, $user, $password);
      return 0;
    }
  }

  function nextid($sequence) {
  // Function returns the next available id for $sequence, if it's not
  // already defined, the first id will start at 1. 
  // This function will create a table for each sequence called
  // '{sequence_name}_seq' in the current database.
    $esequence=ereg_replace("'","''",$sequence)."_seq";
    $query=new query($this, "Select * from $esequence limit 1");
    $query->query($this, "REPLACE INTO $esequence values ('', nextval+1)");
    if ($query->result) {
      $result=@mysql_insert_id($this->connect_id);
    } else {
      $query->query($this, "CREATE TABLE $esequence ( seq char(1) DEFAULT '' NOT NULL, nextval bigint(20) unsigned DEFAULT '0' NOT NULL auto_increment, PRIMARY KEY (seq), KEY (nextval) )");
      $query->query($this, "REPLACE INTO $esequence values ('', nextval+1)");  
      $result=@mysql_insert_id($this->connect_id);
    }
    return $result;
  }           
     
  function close() {
  // Closes the database connection and frees any query results left.

    if ($this->query_id && is_array($this->query_id)) {
      while (list($key,$val)=each($this->query_id)) {
        @mysql_free_result($val);
      }
    }
    $result=@mysql_close($this->connect_id);
    return $result;
  }

  function addquery($query_id) {
  // Function used by the constructor of query. Notifies the
  // this object of the existance of a query_result for later cleanup
  // internal function, don't use it yourself.

    $this->query_id[]=$query_id;
  }
  
};

/************************************** QUERY ***************************/

class query {

  var $result;
  var $row;

  function query(&$db, $query="") {
  // Constructor of the query object.
  // executes the query, notifies the db object of the query result to clean
  // up later
    if($query!=""){
//      if ($this->result) {
//        $this->free(); // query not called as constructor therefore there may
                       // be something to clean up.
//      }
      $this->result=@mysql_query($query, $db->connect_id);
      $db->addquery($this->result);
    }
  }
  
  function getrow() {
  // Gets the next row for processing with $this->field function later.

    $this->row=@mysql_fetch_array($this->result);
    return $this->row;
  }
   
  function numrows() {
  // Gets the number of rows returned in the query
  
    $result=@mysql_num_rows($this->result);
    return $result;
  }

  function error() {
  // Gets the last error message reported for this query
  
    $result=@mysql_error();
    return $result;
  }

  function field($field, $row="-1") {
  // get the value of the field with name $field
  // in the current row or in row $row if supplied

    if($row!=-1){
      $result=@mysql_result($this->result, $row, $field);
    }
    else{
      $result=$this->row[$field];
    }

    if(isset($result)){
      return $result;
    }
    else{
      return '0';
    }
  }

  function firstrow() {
  // return the current row pointer to the first row 
  // (CAUTION: other versions may execute the query again!! (e.g. for oracle))
 
    $result=@mysql_data_seek($this->result,0);
    if($result){
      $result=$this->getrow();
      return $this->row;
    }
    else{
      return 0;
    }
  }

  function free() {
  // free the mysql result tables

    return @mysql_free_result($this->result);
  }

}; // End class

// Custom Create Table Section

  function create_table(&$DB, $table, $table_name){
    GLOBAL $q;
    if($table=="main"){
      $sSQL="CREATE TABLE $table_name (id int(11) DEFAULT '0' NOT NULL, datestamp datetime DEFAULT '0000-00-00 00:00:00' NOT NULL, thread int(11) DEFAULT '0' NOT NULL, parent int(11) DEFAULT '0' NOT NULL, author char(37) DEFAULT '' NOT NULL, subject char(50) DEFAULT '' NOT NULL, email char(50) DEFAULT '' NOT NULL, host char(50) DEFAULT '' NOT NULL, email_reply char(1) NOT NULL DEFAULT 'N', PRIMARY KEY (id), KEY author (author), KEY datestamp (datestamp), KEY subject (subject), KEY thread (thread), KEY parent (parent))";          
      echo "\n<!--$sSQL-->\n";
      $q->query($DB, $sSQL);
      return $q->error();
    }
    elseif($table=="bodies"){
      $sSQL="CREATE TABLE ".$table_name."_bodies (id int(11) DEFAULT '0' NOT NULL, body text DEFAULT '' NOT NULL, thread int(11) DEFAULT '0' NOT NULL, PRIMARY KEY (id), KEY thread (thread))";
      echo "\n<!--$sSQL-->\n";
      $q->query($DB, $sSQL);
      return $q->error();
    }
  }
}
?>